local t = Def.ActorFrame {}

function Actor:GridCommand()
	self:diffuse(color("#C00000"));
	self:linear(0.75);
	self:diffuse(color("#00C000"));
	self:linear(0.75);
	self:diffuse(color("#00C0C0"));
	self:linear(0.75);
	self:diffuse(color("#C000C0"));
	self:linear(0.75);
	self:diffuse(color("#C0C000"));
	self:linear(0.75);
	self:diffuse(color("#C00000"));
end;

local grid = Def.ActorFrame {}

for x=-10,10 do
	for i=1,2 do
		grid[#grid+1] = Def.Quad {
			InitCommand=function(self)
				self:x(SCREEN_WIDTH/20*x);
				(cmd(fadeleft,0.3;faderight,0.3;zoomto,8/i,SCREEN_HEIGHT))(self);
			end;
			OnCommand=i == 1 and cmd(GridCommand;queuecommand,"On") or cmd();
		}
	end
end
for y=-7,7 do
	for i=1,2 do
		grid[#grid+1] = Def.Quad {
			InitCommand=function(self)
				self:y(SCREEN_HEIGHT/14*y);
				(cmd(fadetop,0.3;fadebottom,0.3;zoomto,SCREEN_WIDTH,8/i))(self);
			end;
			OnCommand=i == 1 and cmd(GridCommand;queuecommand,"On") or cmd();
		}
	end
end

t[#t+1] = grid..{
	InitCommand=cmd(x,SCREEN_CENTER_X;y,SCREEN_CENTER_Y;zoom,2);
	OnCommand=cmd(playcommand,"Xrot1");
	Xrot1Command=cmd(rotationx,0;linear,1.5;rotationx,360;queuecommand,"Yrot1");
	Yrot1Command=cmd(rotationy,0;linear,1.5;rotationy,360;queuecommand,"Xrot2");
	Xrot2Command=cmd(rotationx,0;linear,1.5;rotationx,-360;queuecommand,"Yrot2");
	Yrot2Command=cmd(rotationy,0;linear,1.5;rotationy,-360;queuecommand,"Xrot1");
}

--t[#t+1] = LoadActor("10")..{}

t.InitCommand=function(self)
	self:fov(90);
	--self:setupdatefunction(update);
end
return t